const mongoose = require('mongoose');

const contestSchema = new mongoose.Schema({
    title : {
        type: String,
        required: true
    },
    description: {
        type: String,
        required: true
    },
    startDate:{
        type: Date,
        required: true
    },
    endDate:
        {
            type: Date,
            required: true
        },
        duration:{
            type: String,
            required: true
        },
        prizePool:{
            type: Number,
            required: true
        },
        prizes: [
            {
                rank: { type: Number, default: 1 },
                amount: { type: Number, default: 5000 },
                description: { type: String, default: "First Prize + Digital Excellence Certificate" }
            },
            {
                rank: { type: Number, default: 2 }, 
                amount: { type: Number, default: 3500 },
                description: { type: String, default: "Second Prize + Digital Excellence Certificate" }
            },
            {
                rank: { type: Number, default: 3 },
                amount: { type: Number, default: 1500 },
                description: { type: String, default: "Third Prize + Digital Excellence Certificate" }
            }
        ],
    
        rules: [{
            heading: {
                type: String,
                required: true
            },
            descriptions: [{
                type: String,
                required: true
            }]
        }],
        additionalRewards:{
            type: String,
            required: true
        },
        participants:[{
            type: mongoose.Schema.Types.ObjectId,
            ref: 'User'
        }],
        status:{
            type: String,
            enum :['upcoming', 'active', 'ended'],
            default: 'upcoming'
        },
        isVisible:{
            type: Boolean,
            default: true
        },
        featuredLeaderboard: {
            type: Boolean,
            default: false
        }
    
  
},{timestamps: true});
module.exports = mongoose.model('Contest', contestSchema);