const User = require("../Model/User_Model");

/**
 * Middleware to track user activity by updating the lastActive timestamp
 * Only updates if the last update was more than 5 minutes ago to prevent excessive DB writes
 */
const activityTracker = async (req, res, next) => {
  try {
    if (req.userId) {
      // Only update if the last update was more than 5 minutes ago
      await User.updateOne(
        { 
          _id: req.userId,
          lastActive: { $lt: new Date(Date.now() - 5 * 60 * 1000) } 
        },
        { 
          $set: { lastActive: new Date() }
        }
      );
    }
    next();
  } catch (error) {
    console.error("Activity tracking error:", error);
    next(); // Continue even if tracking fails
  }
};

module.exports = activityTracker;
