"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const generic_transformers_1 = require("@redis/client/dist/lib/commands/generic-transformers");
const _1 = require(".");
exports.default = {
    IS_READ_ONLY: false,
    parseCommand(parser, key, options) {
        parser.push('JSON.ARRPOP');
        parser.pushKey(key);
        if (options) {
            parser.push(options.path);
            if (options.index !== undefined) {
                parser.push(options.index.toString());
            }
        }
    },
    transformReply(reply) {
        return (0, generic_transformers_1.isArrayReply)(reply) ?
            reply.map(item => (0, _1.transformRedisJsonNullReply)(item)) :
            (0, _1.transformRedisJsonNullReply)(reply);
    }
};
//# sourceMappingURL=ARRPOP.js.map