import { BlobStringReply, NullReply, UnwrapReply } from '@redis/client/dist/lib/RESP/types';
declare const _default: {
    ARRAPPEND: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, path: import("@redis/client/dist/lib/RESP/types").RedisArgument, json: RedisJSON, ...jsons: RedisJSON[]) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").NumberReply<number> | import("@redis/client/dist/lib/RESP/types").ArrayReply<import("@redis/client/dist/lib/RESP/types").NumberReply<number> | NullReply>;
    };
    arrAppend: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, path: import("@redis/client/dist/lib/RESP/types").RedisArgument, json: RedisJSON, ...jsons: RedisJSON[]) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").NumberReply<number> | import("@redis/client/dist/lib/RESP/types").ArrayReply<import("@redis/client/dist/lib/RESP/types").NumberReply<number> | NullReply>;
    };
    ARRINDEX: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, path: import("@redis/client/dist/lib/RESP/types").RedisArgument, json: RedisJSON, options?: import("./ARRINDEX").JsonArrIndexOptions | undefined) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").NumberReply<number> | import("@redis/client/dist/lib/RESP/types").ArrayReply<import("@redis/client/dist/lib/RESP/types").NumberReply<number> | NullReply>;
    };
    arrIndex: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, path: import("@redis/client/dist/lib/RESP/types").RedisArgument, json: RedisJSON, options?: import("./ARRINDEX").JsonArrIndexOptions | undefined) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").NumberReply<number> | import("@redis/client/dist/lib/RESP/types").ArrayReply<import("@redis/client/dist/lib/RESP/types").NumberReply<number> | NullReply>;
    };
    ARRINSERT: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, path: import("@redis/client/dist/lib/RESP/types").RedisArgument, index: number, json: RedisJSON, ...jsons: RedisJSON[]) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").NumberReply<number> | import("@redis/client/dist/lib/RESP/types").ArrayReply<import("@redis/client/dist/lib/RESP/types").NumberReply<number> | NullReply>;
    };
    arrInsert: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, path: import("@redis/client/dist/lib/RESP/types").RedisArgument, index: number, json: RedisJSON, ...jsons: RedisJSON[]) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").NumberReply<number> | import("@redis/client/dist/lib/RESP/types").ArrayReply<import("@redis/client/dist/lib/RESP/types").NumberReply<number> | NullReply>;
    };
    ARRLEN: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, options?: import("./ARRLEN").JsonArrLenOptions | undefined) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").NumberReply<number> | import("@redis/client/dist/lib/RESP/types").ArrayReply<import("@redis/client/dist/lib/RESP/types").NumberReply<number> | NullReply>;
    };
    arrLen: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, options?: import("./ARRLEN").JsonArrLenOptions | undefined) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").NumberReply<number> | import("@redis/client/dist/lib/RESP/types").ArrayReply<import("@redis/client/dist/lib/RESP/types").NumberReply<number> | NullReply>;
    };
    ARRPOP: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, options?: import("./ARRPOP").RedisArrPopOptions | undefined) => void;
        readonly transformReply: (this: void, reply: NullReply | BlobStringReply<string> | import("@redis/client/dist/lib/RESP/types").ArrayReply<NullReply | BlobStringReply<string>>) => string | number | boolean | Date | {
            [key: string]: RedisJSON;
            [key: number]: RedisJSON;
        } | NullReply | (RedisJSON | NullReply)[] | null;
    };
    arrPop: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, options?: import("./ARRPOP").RedisArrPopOptions | undefined) => void;
        readonly transformReply: (this: void, reply: NullReply | BlobStringReply<string> | import("@redis/client/dist/lib/RESP/types").ArrayReply<NullReply | BlobStringReply<string>>) => string | number | boolean | Date | {
            [key: string]: RedisJSON;
            [key: number]: RedisJSON;
        } | NullReply | (RedisJSON | NullReply)[] | null;
    };
    ARRTRIM: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, path: import("@redis/client/dist/lib/RESP/types").RedisArgument, start: number, stop: number) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").NumberReply<number> | import("@redis/client/dist/lib/RESP/types").ArrayReply<import("@redis/client/dist/lib/RESP/types").NumberReply<number> | NullReply>;
    };
    arrTrim: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, path: import("@redis/client/dist/lib/RESP/types").RedisArgument, start: number, stop: number) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").NumberReply<number> | import("@redis/client/dist/lib/RESP/types").ArrayReply<import("@redis/client/dist/lib/RESP/types").NumberReply<number> | NullReply>;
    };
    CLEAR: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, options?: import("./CLEAR").JsonClearOptions | undefined) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").NumberReply<number>;
    };
    clear: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, options?: import("./CLEAR").JsonClearOptions | undefined) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").NumberReply<number>;
    };
    DEBUG_MEMORY: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, options?: import("./DEBUG_MEMORY").JsonDebugMemoryOptions | undefined) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").NumberReply<number>;
    };
    debugMemory: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, options?: import("./DEBUG_MEMORY").JsonDebugMemoryOptions | undefined) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").NumberReply<number>;
    };
    DEL: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, options?: import("./DEL").JsonDelOptions | undefined) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").NumberReply<number>;
    };
    del: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, options?: import("./DEL").JsonDelOptions | undefined) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").NumberReply<number>;
    };
    FORGET: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, options?: import("./FORGET").JsonForgetOptions | undefined) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").NumberReply<number>;
    };
    forget: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, options?: import("./FORGET").JsonForgetOptions | undefined) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").NumberReply<number>;
    };
    GET: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, options?: import("./GET").JsonGetOptions | undefined) => void;
        readonly transformReply: typeof transformRedisJsonNullReply;
    };
    get: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, options?: import("./GET").JsonGetOptions | undefined) => void;
        readonly transformReply: typeof transformRedisJsonNullReply;
    };
    MERGE: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, path: import("@redis/client/dist/lib/RESP/types").RedisArgument, value: RedisJSON) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").SimpleStringReply<"OK">;
    };
    merge: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, path: import("@redis/client/dist/lib/RESP/types").RedisArgument, value: RedisJSON) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").SimpleStringReply<"OK">;
    };
    MGET: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, keys: import("@redis/client/dist/lib/RESP/types").RedisArgument[], path: import("@redis/client/dist/lib/RESP/types").RedisArgument) => void;
        readonly transformReply: (this: void, reply: (NullReply | BlobStringReply<string>)[]) => (RedisJSON | NullReply)[];
    };
    mGet: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, keys: import("@redis/client/dist/lib/RESP/types").RedisArgument[], path: import("@redis/client/dist/lib/RESP/types").RedisArgument) => void;
        readonly transformReply: (this: void, reply: (NullReply | BlobStringReply<string>)[]) => (RedisJSON | NullReply)[];
    };
    MSET: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, items: import("./MSET").JsonMSetItem[]) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").SimpleStringReply<"OK">;
    };
    mSet: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, items: import("./MSET").JsonMSetItem[]) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").SimpleStringReply<"OK">;
    };
    NUMINCRBY: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, path: import("@redis/client/dist/lib/RESP/types").RedisArgument, by: number) => void;
        readonly transformReply: {
            readonly 2: (reply: UnwrapReply<BlobStringReply<string>>) => number | (number | null)[];
            readonly 3: () => import("@redis/client/dist/lib/RESP/types").ArrayReply<import("@redis/client/dist/lib/RESP/types").NumberReply<number> | NullReply | import("@redis/client/dist/lib/RESP/types").DoubleReply<number>>;
        };
    };
    numIncrBy: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, path: import("@redis/client/dist/lib/RESP/types").RedisArgument, by: number) => void;
        readonly transformReply: {
            readonly 2: (reply: UnwrapReply<BlobStringReply<string>>) => number | (number | null)[];
            readonly 3: () => import("@redis/client/dist/lib/RESP/types").ArrayReply<import("@redis/client/dist/lib/RESP/types").NumberReply<number> | NullReply | import("@redis/client/dist/lib/RESP/types").DoubleReply<number>>;
        };
    };
    /**
     * @deprecated since JSON version 2.0
     */
    NUMMULTBY: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, path: import("@redis/client/dist/lib/RESP/types").RedisArgument, by: number) => void;
        readonly transformReply: {
            readonly 2: (reply: UnwrapReply<BlobStringReply<string>>) => number | (number | null)[];
            readonly 3: () => import("@redis/client/dist/lib/RESP/types").ArrayReply<import("@redis/client/dist/lib/RESP/types").NumberReply<number> | NullReply | import("@redis/client/dist/lib/RESP/types").DoubleReply<number>>;
        };
    };
    /**
     * @deprecated since JSON version 2.0
     */
    numMultBy: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, path: import("@redis/client/dist/lib/RESP/types").RedisArgument, by: number) => void;
        readonly transformReply: {
            readonly 2: (reply: UnwrapReply<BlobStringReply<string>>) => number | (number | null)[];
            readonly 3: () => import("@redis/client/dist/lib/RESP/types").ArrayReply<import("@redis/client/dist/lib/RESP/types").NumberReply<number> | NullReply | import("@redis/client/dist/lib/RESP/types").DoubleReply<number>>;
        };
    };
    OBJKEYS: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, options?: import("./OBJKEYS").JsonObjKeysOptions | undefined) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").ArrayReply<BlobStringReply<string>> | import("@redis/client/dist/lib/RESP/types").ArrayReply<NullReply | import("@redis/client/dist/lib/RESP/types").ArrayReply<BlobStringReply<string>>>;
    };
    objKeys: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, options?: import("./OBJKEYS").JsonObjKeysOptions | undefined) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").ArrayReply<BlobStringReply<string>> | import("@redis/client/dist/lib/RESP/types").ArrayReply<NullReply | import("@redis/client/dist/lib/RESP/types").ArrayReply<BlobStringReply<string>>>;
    };
    OBJLEN: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, options?: import("./OBJLEN").JsonObjLenOptions | undefined) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").NumberReply<number> | import("@redis/client/dist/lib/RESP/types").ArrayReply<import("@redis/client/dist/lib/RESP/types").NumberReply<number> | NullReply>;
    };
    objLen: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, options?: import("./OBJLEN").JsonObjLenOptions | undefined) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").NumberReply<number> | import("@redis/client/dist/lib/RESP/types").ArrayReply<import("@redis/client/dist/lib/RESP/types").NumberReply<number> | NullReply>;
    };
    SET: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, path: import("@redis/client/dist/lib/RESP/types").RedisArgument, json: RedisJSON, options?: import("./SET").JsonSetOptions | undefined) => void;
        readonly transformReply: () => NullReply | import("@redis/client/dist/lib/RESP/types").SimpleStringReply<"OK">;
    };
    set: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, path: import("@redis/client/dist/lib/RESP/types").RedisArgument, json: RedisJSON, options?: import("./SET").JsonSetOptions | undefined) => void;
        readonly transformReply: () => NullReply | import("@redis/client/dist/lib/RESP/types").SimpleStringReply<"OK">;
    };
    STRAPPEND: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, append: string, options?: import("./STRAPPEND").JsonStrAppendOptions | undefined) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").NumberReply<number> | import("@redis/client/dist/lib/RESP/types").ArrayReply<import("@redis/client/dist/lib/RESP/types").NumberReply<number> | NullReply>;
    };
    strAppend: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, append: string, options?: import("./STRAPPEND").JsonStrAppendOptions | undefined) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").NumberReply<number> | import("@redis/client/dist/lib/RESP/types").ArrayReply<import("@redis/client/dist/lib/RESP/types").NumberReply<number> | NullReply>;
    };
    STRLEN: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, options?: import("./STRLEN").JsonStrLenOptions | undefined) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").NumberReply<number> | import("@redis/client/dist/lib/RESP/types").ArrayReply<import("@redis/client/dist/lib/RESP/types").NumberReply<number> | NullReply>;
    };
    strLen: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, options?: import("./STRLEN").JsonStrLenOptions | undefined) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").NumberReply<number> | import("@redis/client/dist/lib/RESP/types").ArrayReply<import("@redis/client/dist/lib/RESP/types").NumberReply<number> | NullReply>;
    };
    TOGGLE: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, path: import("@redis/client/dist/lib/RESP/types").RedisArgument) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").NumberReply<number> | NullReply | import("@redis/client/dist/lib/RESP/types").ArrayReply<import("@redis/client/dist/lib/RESP/types").NumberReply<number> | NullReply>;
    };
    toggle: {
        readonly IS_READ_ONLY: false;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, path: import("@redis/client/dist/lib/RESP/types").RedisArgument) => void;
        readonly transformReply: () => import("@redis/client/dist/lib/RESP/types").NumberReply<number> | NullReply | import("@redis/client/dist/lib/RESP/types").ArrayReply<import("@redis/client/dist/lib/RESP/types").NumberReply<number> | NullReply>;
    };
    TYPE: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, options?: import("./TYPE").JsonTypeOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: () => NullReply | BlobStringReply<string> | import("@redis/client/dist/lib/RESP/types").ArrayReply<NullReply | BlobStringReply<string>>;
            readonly 3: (reply: (NullReply | BlobStringReply<string> | import("@redis/client/dist/lib/RESP/types").ArrayReply<NullReply | BlobStringReply<string>>)[]) => NullReply | BlobStringReply<string> | import("@redis/client/dist/lib/RESP/types").ArrayReply<NullReply | BlobStringReply<string>>;
        };
    };
    type: {
        readonly IS_READ_ONLY: true;
        readonly parseCommand: (this: void, parser: import("@redis/client/dist/lib/client/parser").CommandParser, key: import("@redis/client/dist/lib/RESP/types").RedisArgument, options?: import("./TYPE").JsonTypeOptions | undefined) => void;
        readonly transformReply: {
            readonly 2: () => NullReply | BlobStringReply<string> | import("@redis/client/dist/lib/RESP/types").ArrayReply<NullReply | BlobStringReply<string>>;
            readonly 3: (reply: (NullReply | BlobStringReply<string> | import("@redis/client/dist/lib/RESP/types").ArrayReply<NullReply | BlobStringReply<string>>)[]) => NullReply | BlobStringReply<string> | import("@redis/client/dist/lib/RESP/types").ArrayReply<NullReply | BlobStringReply<string>>;
        };
    };
};
export default _default;
export type RedisJSON = null | boolean | number | string | Date | Array<RedisJSON> | {
    [key: string]: RedisJSON;
    [key: number]: RedisJSON;
};
export declare function transformRedisJsonArgument(json: RedisJSON): string;
export declare function transformRedisJsonReply(json: BlobStringReply): RedisJSON;
export declare function transformRedisJsonNullReply(json: NullReply | BlobStringReply): NullReply | RedisJSON;
//# sourceMappingURL=index.d.ts.map