import { CommandParser } from '@redis/client/dist/lib/client/parser';
import { RedisArgument, ReplyUnion } from '@redis/client/dist/lib/RESP/types';
export interface Terms {
    mode: 'INCLUDE' | 'EXCLUDE';
    dictionary: RedisArgument;
}
export interface FtSpellCheckOptions {
    DISTANCE?: number;
    TERMS?: Terms | Array<Terms>;
    DIALECT?: number;
}
declare const _default: {
    readonly NOT_KEYED_COMMAND: true;
    readonly IS_READ_ONLY: true;
    readonly parseCommand: (this: void, parser: CommandParser, index: RedisArgument, query: RedisArgument, options?: FtSpellCheckOptions) => void;
    readonly transformReply: {
        readonly 2: (rawReply: SpellCheckRawReply) => SpellCheckReply;
        readonly 3: () => ReplyUnion;
    };
    readonly unstableResp3: true;
};
export default _default;
type SpellCheckRawReply = Array<[
    _: string,
    term: string,
    suggestions: Array<[score: string, suggestion: string]>
]>;
type SpellCheckReply = Array<{
    term: string;
    suggestions: Array<{
        score: number;
        suggestion: string;
    }>;
}>;
//# sourceMappingURL=SPELLCHECK.d.ts.map