"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseFilterArgument = exports.parseLatestArgument = void 0;
const _1 = require(".");
function parseLatestArgument(parser, latest) {
    if (latest) {
        parser.push('LATEST');
    }
}
exports.parseLatestArgument = parseLatestArgument;
function parseFilterArgument(parser, filter) {
    parser.push('FILTER');
    parser.pushVariadic(filter);
}
exports.parseFilterArgument = parseFilterArgument;
exports.default = {
    NOT_KEYED_COMMAND: true,
    IS_READ_ONLY: true,
    parseCommand(parser, filter, options) {
        parser.push('TS.MGET');
        parseLatestArgument(parser, options?.LATEST);
        parseFilterArgument(parser, filter);
    },
    transformReply: {
        2(reply, _, typeMapping) {
            return (0, _1.resp2MapToValue)(reply, ([, , sample]) => {
                return {
                    sample: _1.transformSampleReply[2](sample)
                };
            }, typeMapping);
        },
        3(reply) {
            return (0, _1.resp3MapToValue)(reply, ([, sample]) => {
                return {
                    sample: _1.transformSampleReply[3](sample)
                };
            });
        }
    }
};
//# sourceMappingURL=MGET.js.map