import { CommandParser } from '@redis/client/dist/lib/client/parser';
import { ArrayReply, BlobStringReply, Resp2Reply, MapReply, TuplesReply, TypeMapping, RedisArgument } from '@redis/client/dist/lib/RESP/types';
import { RedisVariadicArgument } from '@redis/client/dist/lib/commands/generic-transformers';
import { SampleRawReply, Timestamp } from '.';
import { TsRangeOptions } from './RANGE';
export type TsMRangeRawReply2 = ArrayReply<TuplesReply<[
    key: BlobStringReply,
    labels: never,
    samples: ArrayReply<Resp2Reply<SampleRawReply>>
]>>;
export type TsMRangeRawReply3 = MapReply<BlobStringReply, TuplesReply<[
    labels: never,
    metadata: never,
    samples: ArrayReply<SampleRawReply>
]>>;
export declare function createTransformMRangeArguments(command: RedisArgument): (parser: CommandParser, fromTimestamp: Timestamp, toTimestamp: Timestamp, filter: RedisVariadicArgument, options?: TsRangeOptions) => void;
declare const _default: {
    readonly NOT_KEYED_COMMAND: true;
    readonly IS_READ_ONLY: true;
    readonly parseCommand: (parser: CommandParser, fromTimestamp: Timestamp, toTimestamp: Timestamp, filter: RedisVariadicArgument, options?: TsRangeOptions | undefined) => void;
    readonly transformReply: {
        readonly 2: (this: void, reply: TsMRangeRawReply2, _?: any, typeMapping?: TypeMapping) => MapReply<BlobStringReply<string>, {
            timestamp: import("@redis/client/dist/lib/RESP/types").NumberReply<number>;
            value: number;
        }[]>;
        readonly 3: (this: void, reply: TsMRangeRawReply3) => MapReply<BlobStringReply<string>, {
            timestamp: import("@redis/client/dist/lib/RESP/types").NumberReply<number>;
            value: import("@redis/client/dist/lib/RESP/types").DoubleReply<number>;
        }[]>;
    };
};
export default _default;
//# sourceMappingURL=MRANGE.d.ts.map