"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractResp3MRangeSources = exports.createTransformMRangeGroupByArguments = exports.parseGroupByArguments = exports.TIME_SERIES_REDUCERS = void 0;
const _1 = require(".");
const RANGE_1 = require("./RANGE");
const MGET_1 = require("./MGET");
exports.TIME_SERIES_REDUCERS = {
    AVG: 'AVG',
    SUM: 'SUM',
    MIN: 'MIN',
    MAX: 'MAX',
    RANGE: 'RANGE',
    COUNT: 'COUNT',
    STD_P: 'STD.P',
    STD_S: 'STD.S',
    VAR_P: 'VAR.P',
    VAR_S: 'VAR.S'
};
function parseGroupByArguments(parser, groupBy) {
    parser.push('GROUPBY', groupBy.label, 'REDUCE', groupBy.REDUCE);
}
exports.parseGroupByArguments = parseGroupByArguments;
function createTransformMRangeGroupByArguments(command) {
    return (parser, fromTimestamp, toTimestamp, filter, groupBy, options) => {
        parser.push(command);
        (0, RANGE_1.parseRangeArguments)(parser, fromTimestamp, toTimestamp, options);
        (0, MGET_1.parseFilterArgument)(parser, filter);
        parseGroupByArguments(parser, groupBy);
    };
}
exports.createTransformMRangeGroupByArguments = createTransformMRangeGroupByArguments;
function extractResp3MRangeSources(raw) {
    const unwrappedMetadata2 = raw;
    if (unwrappedMetadata2 instanceof Map) {
        return unwrappedMetadata2.get('sources');
    }
    else if (unwrappedMetadata2 instanceof Array) {
        return unwrappedMetadata2[1];
    }
    else {
        return unwrappedMetadata2.sources;
    }
}
exports.extractResp3MRangeSources = extractResp3MRangeSources;
exports.default = {
    IS_READ_ONLY: true,
    parseCommand: createTransformMRangeGroupByArguments('TS.MRANGE'),
    transformReply: {
        2(reply, _, typeMapping) {
            return (0, _1.resp2MapToValue)(reply, ([_key, _labels, samples]) => {
                return {
                    samples: _1.transformSamplesReply[2](samples)
                };
            }, typeMapping);
        },
        3(reply) {
            return (0, _1.resp3MapToValue)(reply, ([_labels, _metadata1, metadata2, samples]) => {
                return {
                    sources: extractResp3MRangeSources(metadata2),
                    samples: _1.transformSamplesReply[3](samples)
                };
            });
        }
    },
};
//# sourceMappingURL=MRANGE_GROUPBY.js.map