"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createTransformMRangeSelectedLabelsArguments = void 0;
const _1 = require(".");
const RANGE_1 = require("./RANGE");
const MGET_1 = require("./MGET");
function createTransformMRangeSelectedLabelsArguments(command) {
    return (parser, fromTimestamp, toTimestamp, selectedLabels, filter, options) => {
        parser.push(command);
        (0, RANGE_1.parseRangeArguments)(parser, fromTimestamp, toTimestamp, options);
        (0, _1.parseSelectedLabelsArguments)(parser, selectedLabels);
        (0, MGET_1.parseFilterArgument)(parser, filter);
    };
}
exports.createTransformMRangeSelectedLabelsArguments = createTransformMRangeSelectedLabelsArguments;
exports.default = {
    IS_READ_ONLY: true,
    parseCommand: createTransformMRangeSelectedLabelsArguments('TS.MRANGE'),
    transformReply: {
        2(reply, _, typeMapping) {
            return (0, _1.resp2MapToValue)(reply, ([_key, labels, samples]) => {
                return {
                    labels: (0, _1.transformRESP2Labels)(labels, typeMapping),
                    samples: _1.transformSamplesReply[2](samples)
                };
            }, typeMapping);
        },
        3(reply) {
            return (0, _1.resp3MapToValue)(reply, ([_key, labels, samples]) => {
                return {
                    labels,
                    samples: _1.transformSamplesReply[3](samples)
                };
            });
        }
    },
};
//# sourceMappingURL=MRANGE_SELECTED_LABELS.js.map