"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.transformRangeArguments = exports.parseRangeArguments = exports.TIME_SERIES_BUCKET_TIMESTAMP = void 0;
const _1 = require(".");
exports.TIME_SERIES_BUCKET_TIMESTAMP = {
    LOW: '-',
    MIDDLE: '~',
    END: '+'
};
function parseRangeArguments(parser, fromTimestamp, toTimestamp, options) {
    parser.push((0, _1.transformTimestampArgument)(fromTimestamp), (0, _1.transformTimestampArgument)(toTimestamp));
    if (options?.LATEST) {
        parser.push('LATEST');
    }
    if (options?.FILTER_BY_TS) {
        parser.push('FILTER_BY_TS');
        for (const timestamp of options.FILTER_BY_TS) {
            parser.push((0, _1.transformTimestampArgument)(timestamp));
        }
    }
    if (options?.FILTER_BY_VALUE) {
        parser.push('FILTER_BY_VALUE', options.FILTER_BY_VALUE.min.toString(), options.FILTER_BY_VALUE.max.toString());
    }
    if (options?.COUNT !== undefined) {
        parser.push('COUNT', options.COUNT.toString());
    }
    if (options?.AGGREGATION) {
        if (options?.ALIGN !== undefined) {
            parser.push('ALIGN', (0, _1.transformTimestampArgument)(options.ALIGN));
        }
        parser.push('AGGREGATION', options.AGGREGATION.type, (0, _1.transformTimestampArgument)(options.AGGREGATION.timeBucket));
        if (options.AGGREGATION.BUCKETTIMESTAMP) {
            parser.push('BUCKETTIMESTAMP', options.AGGREGATION.BUCKETTIMESTAMP);
        }
        if (options.AGGREGATION.EMPTY) {
            parser.push('EMPTY');
        }
    }
}
exports.parseRangeArguments = parseRangeArguments;
function transformRangeArguments(parser, key, fromTimestamp, toTimestamp, options) {
    parser.pushKey(key);
    parseRangeArguments(parser, fromTimestamp, toTimestamp, options);
}
exports.transformRangeArguments = transformRangeArguments;
exports.default = {
    IS_READ_ONLY: true,
    parseCommand(...args) {
        const parser = args[0];
        parser.push('TS.RANGE');
        transformRangeArguments(...args);
    },
    transformReply: {
        2(reply) {
            return _1.transformSamplesReply[2](reply);
        },
        3(reply) {
            return _1.transformSamplesReply[3](reply);
        }
    }
};
//# sourceMappingURL=RANGE.js.map