const mongoose = require('mongoose');
const User = require('../Model/User_Model');
require('dotenv').config();

async function fixUnlockedEpisodes() {
  try {
    await mongoose.connect(process.env.MONGODB_URI);
    console.log('Connected to MongoDB');
    
    // Find all users
    const users = await User.find({});
    console.log(`Found ${users.length} users`);
    
    let fixedCount = 0;
    
    for (const user of users) {
      // Check if unlockedEpisodes exists and is not an object
      if (user.unlockedEpisodes && typeof user.unlockedEpisodes !== 'object') {
        console.log(`Fixing user ${user._id} (${user.username})`);
        
        // Reset to empty object
        user.unlockedEpisodes = {};
        await user.save();
        fixedCount++;
      }
      // If it's an array, convert to object
      else if (Array.isArray(user.unlockedEpisodes)) {
        console.log(`Fixing array for user ${user._id} (${user.username})`);
        user.unlockedEpisodes = {};
        await user.save();
        fixedCount++;
      }
    }
    
    console.log(`Fixed ${fixedCount} users`);
    console.log('Migration completed successfully');
  } catch (error) {
    console.error('Migration failed:', error);
  } finally {
    mongoose.disconnect();
    console.log('Disconnected from MongoDB');
  }
}

fixUnlockedEpisodes();

// For run this migration :- node scripts/fixUnlockedEpisodes.js

