const mongoose = require('mongoose');
const User = require('../Model/User_Model');
require('dotenv').config();

mongoose.connect(process.env.MONGODB_URI)
  .then(async () => {
    console.log('Connected to MongoDB');
    
    try {
      // Update all users who don't have the initialCoinGranted flag
      const result = await User.updateMany(
        { initialCoinGranted: { $ne: true } },
        { 
          $set: { initialCoinGranted: true },
          $inc: { coins: 100 }
        }
      );
      
      console.log(`Initial coins granted to ${result.modifiedCount} users`);
    } catch (error) {
      console.error('Error granting initial coins:', error);
    } finally {
      mongoose.disconnect();
      console.log('Disconnected from MongoDB');
    }
  })
  .catch(err => {
    console.error('Failed to connect to MongoDB:', err);
  });
